require(lattice)
require(grid)

# read in lead data
lead.away <- read.csv("data/away.csv",header=F);
lead.home <- read.csv("data/home.csv",header=F);

# fit smoothing splines
splines.away <- smooth.spline(lead.away$V1, lead.away$V2);
splines.home <- smooth.spline(lead.home$V1, lead.home$V2);

# set trellis options
trellis.par.set("fontsize", list(text=14, points=10))

# setup labels
title <- "Average Number of Starters in Game based on Lead"
# setup the X axis
xLIM <- c(-36,seq(-35,35,by=10),36)
xTIX <- c(seq(-35,35,by=5))
xLAB <- c("-35","","-25","","-15","","-5","0","5","","15","","25","","35")

# setup panel
panel.q <- function (x, y, ...) {
	lcol <- "black"
	ltyp <- "dotted"
	lwidth <- 1

	# time
	llines(-35, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(-25, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(-15, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(-5, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(0, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(5, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(15, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(25, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)
	llines(35, y=c(1,5), col=lcol, lwd=lwidth, lty=ltyp)

	# starter lines
	llines(x=c(-36,36), y=5, col=lcol, lwd=lwidth, lty=ltyp)
	llines(x=c(-36,36), y=4, col=lcol, lwd=lwidth, lty=ltyp)
	llines(x=c(-36,36), y=3, col=lcol, lwd=lwidth, lty=ltyp)
	llines(x=c(-36,36), y=2, col=lcol, lwd=lwidth, lty=ltyp)
	llines(x=c(-36,36), y=1, col=lcol, lwd=lwidth, lty=ltyp)
	llines(x=c(-36,36), y=0, col=lcol, lwd=lwidth, lty=ltyp)

	# away lead
	lpoints(x=lead.away$V1, y=lead.away$V2, col="red");

	# splines
	llines(x=-35:35, predict(splines.home, x=-35:35)$y, col="blue");
	llines(x=-35:35, predict(splines.away, x=-35:35)$y, col="red");

	panel.xyplot(x, y, ...)
}

# plot the data
fig <- xyplot(lead.home$V2 ~ lead.home$V1, type="p", col="blue", panel=panel.q,
	xlim=xLIM,
	ylim=range(0.95,5.05),
	main=title,
	xlab="Average # of Starters vs. Lead",
	ylab="",
	scales=list(
	x=list(at=xTIX,labels=xLAB,tck=c(1,0)),
	y=list(at=c(seq(1,5,by=1)),labels=c("1","2","3","4","5"),tck=c(5,4,3,2,1))))

# save image as PDF
#trellis.device(dev=pdf, file="starters_vs_lead.pdf", width="8.5", height="3"); # default width=height=7

print(fig);

# save the file
#graphics.off();
